/*
 * Decompiled with CFR 0.152.
 */
package com.aratek.trustfinger.common;

import android.graphics.Bitmap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class CommonUtil {
    public static int calcLittleEndian(byte[] byArray) {
        if (byArray == null || byArray.length != 2) {
            return 0;
        }
        return (byArray[0] & 0xFF) + (byArray[1] << 8);
    }

    public static byte calculateLRC(byte[] byArray, int n, int n2) {
        byte by = 0;
        for (int i = 0; i < n2; ++i) {
            by = (byte)(by ^ byArray[n + i]);
        }
        return by;
    }

    public static String bytes2HexString(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toHexString(byArray[i] & 0xFF);
            if (string2.length() == 1) {
                string2 = "0" + string2;
            }
            string = string + string2.toUpperCase();
        }
        return string;
    }

    public static byte[] mergeArray(byte[] ... byArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n2 += byArray[i].length;
        }
        byte[] byArray2 = new byte[n2];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            int n3 = byArray[n2].length;
            if (n3 == 0) continue;
            System.arraycopy(byArray[n2], 0, byArray2, n, n3);
            n += n3;
        }
        return byArray2;
    }

    public static byte[] getMergeBytes(byte[] byArray, byte[] byArray2) {
        int n;
        int n2 = byArray.length;
        int n3 = byArray2.length;
        byte[] byArray3 = new byte[n2 + n3];
        for (n = 0; n < n2; ++n) {
            byArray3[n] = byArray[n];
        }
        for (n = 0; n < n3; ++n) {
            byArray3[n2 + n] = byArray2[n];
        }
        return byArray3;
    }

    public static void saveData(String object, byte[] byArray) throws IOException {
        if (!((File)(object = new File((String)object))).exists()) {
            ((File)object).createNewFile();
        }
        object = new FileOutputStream((File)object);
        ((FileOutputStream)object).write(byArray);
        ((FileOutputStream)object).close();
    }

    public static void saveBmp(String object, Bitmap bitmap) throws IOException {
        Object object2;
        if (!((File)(object = new File((String)object))).exists()) {
            try {
                ((File)object).createNewFile();
            }
            catch (IOException iOException) {
                object2 = iOException;
                iOException.printStackTrace();
            }
        }
        try {
            object2 = new FileOutputStream((File)object);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)object2);
            ((OutputStream)object2).flush();
            ((FileOutputStream)object2).close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = fileNotFoundException;
            fileNotFoundException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public static byte[] getDataFromFile(String object) {
        File file = null;
        byte[] byArray = null;
        try {
            file = new File((String)object);
            if (file.exists()) {
                object = new FileInputStream(file);
                byArray = new byte[((FileInputStream)object).available()];
                ((FileInputStream)object).read(byArray);
                ((FileInputStream)object).close();
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public static byte[] readByteArrayFormStream(InputStream object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)object).read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            object = byArray2;
            return byArray2;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return new byte[0];
        }
    }

    public static Bitmap convert8bit(byte[] object, int n, int n2) {
        byte[] byArray = new byte[((byte[])object).length << 2];
        for (int i = 0; i < ((byte[])object).length; ++i) {
            byte by = object[i];
            byArray[(i << 2) + 2] = by;
            byArray[(i << 2) + 1] = by;
            byArray[i << 2] = by;
            byArray[(i << 2) + 3] = -1;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        object = bitmap;
        bitmap.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(byArray));
        return object;
    }

    public static Bitmap convert24bit(byte[] object, int n, int n2) {
        byte[] byArray = new byte[((byte[])object).length << 2];
        for (int i = 0; i < ((byte[])object).length / 3; ++i) {
            byArray[i << 2] = object[i * 3];
            byArray[(i << 2) + 1] = object[i * 3 + 1];
            byArray[(i << 2) + 2] = object[i * 3 + 2];
            byArray[(i << 2) + 3] = -1;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        object = bitmap;
        bitmap.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(byArray));
        return object;
    }

    public static Bitmap convert8bit(InputStream inputStream, int n, int n2) {
        return CommonUtil.convert8bit(CommonUtil.readByteArrayFormStream(inputStream), n, n2);
    }

    public static Bitmap convert24bit(InputStream inputStream, int n, int n2) {
        return CommonUtil.convert24bit(CommonUtil.readByteArrayFormStream(inputStream), n, n2);
    }
}

