﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Demo
{
    public class CaptureTabProfile
    {
        public bool AutoSave { get; set; } = false;
        public string StorageDirectory { get; set; }
        public int MinuFormat { get; set; } = 0;
        public int CaptureImageFormat { get; set; }
        public int ImageQulity { get; set; } = 50;
        public int Compression { get; set; } = 100;
    }

    public class EnrollTabProfile
    {
        public int ImageQulity { get; set; } = 50;
    }

    public class VerifyTabProfile
    {
        public int ImageQulity { get; set; } = 50;
        public int SecurityLevelCombox { get; set; } = 3;
    }
    public class IdentifyTabProfile
    {
        public int ImageQulity { get; set; } = 50;
        public int SecurityLevelCombox { get; set; } = 3;
        public int DisplayTop { get; set; } = 50;
    }

    public class Profile
    {

        public bool EnableLED { get; set; } = true;
        #region Capture Tab
        public CaptureTabProfile CaptureTab { get; set; } = new CaptureTabProfile();

        public EnrollTabProfile EnrollTabProfile { get; set; } = new EnrollTabProfile();

        public VerifyTabProfile VerifyTabProfile { get; set; } = new VerifyTabProfile();

        public IdentifyTabProfile IdentifyTabProfile { get; set; } = new IdentifyTabProfile();
        #endregion

        public static Profile LoadProfile()
        {
            string dir = AppDomain.CurrentDomain.BaseDirectory;
            string file = Path.Combine(dir, "Profile.json");
            if (File.Exists(file))
            {
                string content = File.ReadAllText(file);
                var p = JsonConvert.DeserializeObject<Profile>(content);              
                return p;
            }
            else
            {
                Profile p = new Profile();
                string capture = Path.Combine(dir, "FingerData");
                if(!Directory.Exists(capture))
                {
                    Directory.CreateDirectory(capture);
                }
                p.CaptureTab.StorageDirectory = capture;               
                return p;
            }
        }

        public void Save()
        {
            string content = JsonConvert.SerializeObject(this);
            string dir = AppDomain.CurrentDomain.BaseDirectory;
            string file = Path.Combine(dir, "Profile.json");

            File.WriteAllText(file, content);
        }
    }
}
